/**HEADER********************************************************************
* 
* Copyright (c) 2010 Linear Tech Corporation;
* All Rights Reserved
*
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 1989-2008 ARC International;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: cgi.h$
* $Version : Custom for LTC Board Demo Suite
* $Date    : Sep-10-2010$
*
* Comments:
*
*   
*
*END************************************************************************/

#ifndef _cgi_h_
#define _cgi_h_

#if defined BSP_TWR_K60D100M
//Kinetis does not use the following declaration
#else
extern FILE_PTR adc_fd[ADC_HW_CHANNELS];
#endif

//These are in cgi-utils.c
_mqx_int cgi_ipstat(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_icmpstat(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_udpstat(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_tcpstat(HTTPSRV_CGI_REQ_STRUCT *session);

_mqx_int cgi_rtc_data(HTTPSRV_CGI_REQ_STRUCT *session);

_mqx_int cgi_toggle_led1(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_toggle_led2(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_toggle_led3(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_toggle_led4(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_get_varval(char *, char *, char *, _mqx_int );
//My functions
_mqx_int cgi_button_1(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_test_data(HTTPSRV_CGI_REQ_STRUCT *session);
//_mqx_int cgi_receive_data(HTTPSRV_CGI_REQ_STRUCT *session);



//These are in cgi-ltctwr
_mqx_int cgi_ltc1859_data(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_ltc1859_set(HTTPSRV_CGI_REQ_STRUCT *session);

_mqx_int cgi_ltc2498_data(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_ltc2498_set(HTTPSRV_CGI_REQ_STRUCT *session);

_mqx_int cgi_ltc2600_set(HTTPSRV_CGI_REQ_STRUCT *session);

_mqx_int cgi_ltc2704_set(HTTPSRV_CGI_REQ_STRUCT *session);


//These are in cgi-datalogger
_mqx_int cgi_adcdatalogger_set(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_sampler_progress(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_sync_rtc(HTTPSRV_CGI_REQ_STRUCT *sesstion);
//


//These are in cgi-thermocouple
_mqx_int cgi_thermocouple_set(HTTPSRV_CGI_REQ_STRUCT *session);
_mqx_int cgi_thermocouple_data(HTTPSRV_CGI_REQ_STRUCT *session);


#define CGI_SEND_NUM(val)							\
{													\
	char str[20];									\
        uint_32  temp;                                           \
	sprintf((char_ptr)&str, "%li\n", val);			\
        temp = strlen(str);  ptr += temp;                                     \
        memcpy(&buffer[ptr], str,  temp);                                     \
}

#define CGI_SEND_DATA() \
          { \
response.ses_handle = param->ses_handle; \
        response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN; \
        response.status_code = 200; \
        response.data = buffer; \
        response.data_length = ptr; \
        response.content_length = response.data_length; \
       /* Send response */   \
       HTTPSRV_cgi_write(&response); \
         ptr = 0;                    \
       }
#define CGI_SEND_STR(val)							\
{													\
	httpd_sendstr(session->sock, val);				\
	httpd_sendstr(session->sock, "\n");				\
}





#endif
